const { Client, LocalAuth } = require('whatsapp-web.js');
const qrcode = require('qrcode-terminal');
const express = require('express');
const cors = require('cors');

const app = express();
app.use(cors());
app.use(express.json());

// ====================== KONFIGURASI ======================
const PORT = 250;
const myToken = 'mytok3n';

// ====================== STATUS GLOBAL ======================
let serverStatus = 'init';   // init | qrcode | waReady
let qrCode = '';

// ====================== INIT WHATSAPP ======================
const client = new Client({
    puppeteer: { headless: true },
    authStrategy: new LocalAuth(),
    webVersionCache: { type: 'none' }
});

// ====================== EVENT WHATSAPP ======================
client.on('qr', (qr) => {
    serverStatus = 'qrcode';
    qrCode = qr;
    qrcode.generate(qr, { small: true });
    console.log('QR Code tersedia');
});

client.on('ready', () => {
    serverStatus = 'waReady';
    qrCode = '';
    console.log('Client Siap !');
});

client.on('authenticated', () => {
    console.log('WhatsApp Terautentikasi');
});

client.initialize();

// ====================== API ENDPOINT ======================

// 1️⃣ CEK STATUS + QR CODE
app.get('/', (req, res) => {
    if (req.query.token !== myToken) {
        return res.status(401).json({ error: 'Token Invalid' });
    }

    res.json({
        serverstatus: serverStatus,
        qrcode: qrCode
    });
});

// 2️⃣ AMBIL KONTAK
// 2️⃣ AMBIL KONTAK INDONESIA (NOMOR + NAMA, BUKAN GRUP)
app.get('/get_contact', async (req, res) => {
    try {
        if (req.query.token !== myToken) {
            return res.status(401).json({ error: 'Token Invalid' });
        }

        if (serverStatus !== 'waReady') {
            return res.status(400).json({ error: 'WhatsApp belum siap' });
        }

        const contacts = await client.getContacts();

        const result = contacts
            .filter(c => {
                const number = c.id?.user; // contoh: 628123456789
                return (
                    c.id?.server === 'c.us' &&
                    !c.isGroup &&
                    !c.isMe &&
                    number &&
                    number.startsWith('62')
                );
            })
            .map(c => ({
                name: c.name || c.pushname || 'Tanpa Nama',
                number: c.id.user
            }));

        res.json(result);
    } catch (err) {
        console.error('ERROR get_contact:', err);
        res.status(500).json({ error: 'Gagal mengambil kontak' });
    }
});

// 3️⃣ LOGOUT & RESET (QR BARU)
app.get('/logout', async (req, res) => {
    if (req.query.token !== myToken) {
        return res.status(401).json({ error: 'Token Invalid' });
    }

    try {
        await client.logout();
        serverStatus = 'qrcode';
        qrCode = '';

        await client.initialize();

        res.json({ status: 'logout & restart' });
    } catch (err) {
        res.status(500).json({ error: err.message });
    }
});

// ====================== SERVER ======================
app.listen(PORT, () => {
    serverStatus = 'portReady';
    console.log(`Server berjalan di port ${PORT}`);
});
